/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  double MSfGaussRand (double rms)

Purpose:
  Generate a Gaussian pseudo-random value

Description:
  This routine generates pseudo-random numbers with a Gaussian distribution.
  The numbers are generated by summing 12 uniformly distributed pseudo-random
  numbers.  The result is approximately Gaussian (central limit theorem) with a
  range between -6 and +6 standard deviations.  This routine uses the function
  UTfUnifRand as the source of uniform pseudo-random numbers.

Parameters:
  <-  double MSfGaussRand
      Gaussian deviate, mean zero, standard deviation rms
   -> double rms
      Root-mean square value of the deviate (standard deviation)

Author / revision:
  P. Kabal  Copyright (C) 2003
  $Revision: 1.7 $  $Date: 2003/05/09 02:29:38 $

-------------------------------------------------------------------------*/

#include <libtsp.h>


double
MSfGaussRand (double rms)

{
  int i;
  double sum;

/* Add twelve uniform deviates, each in the range (0,1) */
   sum = 0.0;
   for (i = 0; i < 12; ++i)
     sum += MSfUnifRand ();

  return (rms * (sum - 6.0));
}
